#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#ifndef _WIN32
#include <unistd.h>
#else
#include <windows.h>
#endif
#include "config.h"
#include "util.h"
#include "boinc_api.h"
#include "str_util.h"

// helper class that makes a C-string from a character array and length,
// automatically deleted on destruction.
// Fortran strings are passed as character array plus length
//
class STRING_FROM_FORTRAN {
  char* p;
  int   length;
public:
    STRING_FROM_FORTRAN(const char* s, int s_len) {
      length = strlen(s);
        p = new char[s_len + 0];
#ifdef debug
	fprintf(stderr,"STRING_FROM_FORTRAN: infile=%s lengthin=%d length=%d\n",s,s_len,length);
#endif
        memcpy(p, s, s_len);
        p[s_len] = 0;
#ifdef debug
	fprintf(stderr,"STRING_FROM_FORTRAN: p=");
        for(int i=0;i<=s_len;i++) fprintf(stderr,"%c",p[i]);
	fprintf(stderr,"\n");
#endif
    }
    ~STRING_FROM_FORTRAN() { delete [] p; }
    void strip_whitespace() {
        ::strip_whitespace(p);
    }
    const char* c_str() { return p; }
};

// remove terminating null and pad with blanks a la FORTRAN
//
static void string_to_fortran(char* p, int len) {
  int length=strlen(p);
#ifdef debug
  fprintf(stderr,"cboincresolvefilename: string_to_fortran; length=%d, len=%d\n",length,len);
#endif
    for (int i=length; i<len; i++) {
        p[i] = ' ';
    }
}

extern "C" 
#ifdef gnu
void cboincresolvefilename_(const char (&infile)[64],char (&inpath)[256], int (&lengthin), int (&lengthout))
#else
void cboincresolvefilename (const char* infile, char* inpath, int lengthin, int lengthout)
#endif
{

#ifndef gnu
    fprintf(stderr,"cboincresolvefilename: GNU NOT DEFINED\n");
#endif

#ifdef debug
    fprintf(stderr,"cboincresolvefilename: Trying to resolve name for:%s(size=%d)\n",infile,lengthin);
#endif
    STRING_FROM_FORTRAN sff(infile, lengthin);
    sff.strip_whitespace();
    boinc_resolve_filename(sff.c_str(), inpath, lengthout);
#ifdef debug
    fprintf(stderr,"cboincresolvefilename: Resolved name before translation to FORTRAN=%s(size=%d)\n",inpath,lengthout);
#endif
        string_to_fortran(inpath, lengthout);
#ifdef debug
    fprintf(stderr,"cboincresolvefilename: Resolved name=%s(size=%d)\n",inpath,lengthout);
#endif
}
