#/bin/sh

#
# See: http://boinc.berkeley.edu/trac/wiki/AndroidBuildApp#
#

# Script to compile various BOINC libraries for Android to be used
# by science applications

COMPILEBOINC="yes"
CONFIGURE="yes"
MAKECLEAN="yes"

export BOINC="/home/carlgt1/projects/boinc" #BOINC source code
export OPENSSL_DIR="/home/carlgt1/projects/extra/openssl-1.0.1e"
export CURL_DIR="/home/carlgt1/projects/extra/curl-7.31.0"
export PKG_CONFIG_DEBUG_SPEW=1

export ANDROIDTC="/usr/local/android/android-tc"
export TCBINARIES="$ANDROIDTC/bin"
export TCINCLUDES="$ANDROIDTC/arm-linux-androideabi"
export TCSYSROOT="$ANDROIDTC/sysroot"
export STDCPPTC="$TCINCLUDES/lib/libstdc++.a"

export PATH="$PATH:$TCBINARIES:$TCINCLUDES/bin"
export CC=arm-linux-androideabi-gcc
export CXX=arm-linux-androideabi-g++
export LD=arm-linux-androideabi-ld
#export CFLAGS="--sysroot=$TCSYSROOT -Wall -O3 -fomit-frame-pointer"
export CFLAGS="--sysroot=$TCSYSROOT -Wall -g -O0 -fno-omit-frame-pointer"
export CPPFLAGS="-DANDROID -DDECLARE_TIMEZONE -I$BOINC/lib/android -I$TCINCLUDES/include"
export CXXFLAGS="--sysroot=$TCSYSROOT -DANDROID -Wall -fno-omit-frame-pointer -funroll-loops -fexceptions -g -O0"
export LDFLAGS="-L$TCSYSROOT/usr/lib -L$TCINCLUDES/lib"
export LIBS=" -llog"
export GDB_CFLAGS="--sysroot=$TCSYSROOT -Wall -g -I$TCINCLUDES/include -I$BOINC/lib/android"
export PKG_CONFIG_SYSROOT_DIR=$TCSYSROOT
export PKG_CONFIG_PATH=$CURL_DIR/lib/pkgconfig:$OPENSSL_DIR/lib/pkgconfig

if [ -n "$COMPILEBOINC" ]; then
echo "==================building Libraries from $BOINC=========================="
cd $BOINC
if [ -n "$MAKECLEAN" ]; then
make clean
fi
if [ -n "$CONFIGURE" ]; then
./_autosetup
./configure --host=arm-linux --with-boinc-platform="arm-android-linux-gnu" --with-ssl=$TCINCLUDES --disable-server --disable-manager --disable-client --disable-shared --enable-static
fi
make
make stage

echo "=============================BOINC done============================="

fi
