#/bin/sh
#script to compile Wrapper for Android

export ANDROIDTC="/usr/local/android/android-tc"
export TCBINARIES="$ANDROIDTC/bin"
export TCINCLUDES="$ANDROIDTC/arm-linux-androideabi"
export TCSYSROOT="$ANDROIDTC/sysroot"
export STDCPPTC="$TCINCLUDES/lib/libstdc++.a"
export BOINC_DIR="/home/carlgt1/projects/boinc"
export BOINC_API_DIR="$BOINC_DIR/api"
export BOINC_LIB_DIR="$BOINC_DIR/lib"
export BOINC_ZIP_DIR="$BOINC_DIR/zip"

export PATH="$PATH:$TCBINARIES:$TCINCLUDES/bin"
export CC=arm-linux-androideabi-gcc
export CXX=arm-linux-androideabi-g++
export LD=arm-linux-androideabi-ld
export CFLAGS="--sysroot=$TCSYSROOT -DANDROID -DDECLARE_TIMEZONE -Wall -I$TCINCLUDES/include -g -O0 -I$TCINCLUDES/include -I$BOINC_DIR -I$BOINC_LIB_DIR -I$BOINC_API_DIR -I$BOINC_ZIP_DIR"
export CXXFLAGS="--sysroot=$TCSYSROOT -DANDROID -Wall -fno-omit-frame-pointer -funroll-loops -fexceptions -g -O0 -I$TCINCLUDES/include -I$BOINC_DIR -I$BOINC_LIB_DIR -I$BOINC_API_DIR -I$BOINC_ZIP_DIR"
export LDFLAGS="-L$TCSYSROOT/usr/lib -L$TCINCLUDES/lib -L$BOINC_DIR -L$BOINC_LIB_DIR -L$BOINC_API_DIR -L$BOINC_ZIP_DIR -llog"
export GDB_CFLAGS="--sysroot=$TCSYSROOT -Wall -g -I$TCINCLUDES/include"

# Prepare android toolchain and environment
../../android/build_androidtc.sh

make -f Makefile_android
