#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

// Unix: pthreads doesn't provide an API for getting per-thread CPU time,
// so just get the process's CPU time
//

int boinc_calling_thread_cpu_time(double &cpu_t) {
    struct rusage ru;

    int retval = getrusage(RUSAGE_SELF, &ru);
    if (retval) return -1;
    cpu_t = (double)ru.ru_utime.tv_sec + ((double)ru.ru_utime.tv_usec) / 1e6;
    cpu_t += (double)ru.ru_stime.tv_sec + ((double)ru.ru_stime.tv_usec) / 1e6;
    return 0;
}


// return time of day (seconds since 1970) as a double
//
double dtime() {
    struct timeval tv;
    gettimeofday(&tv, 0);
    return tv.tv_sec + (tv.tv_usec/1.e6);
}

void benchmark_wait_to_start(int which) {
    /*while (1) {
        if (boinc_file_exists(file_names[which])) {
            break;
        }
        boinc_sleep(0.1);
    }*/
}

bool benchmark_time_to_stop(int which) {
   static int i = 0;
   return (bool)(i++ < 1e6);
}

