#include <stdio.h>

#include "dhrystone.h"

extern int boinc_calling_thread_cpu_time(double& cpu);
extern int dhrystone(double& Vax_Mips, double& int_loops, double& int_time, double min_cpu_time);
extern int whetstone(double& flops, double& cpu_time, double min_cpu_time);

int main(int argc, char** argv)
{
   int retval;
   const double MIN_CPU_TIME=10.0;
   double vax_mips, int_loops=0, int_time=0, fp_time, p_fpops;

   retval = whetstone(p_fpops, fp_time, MIN_CPU_TIME);
   if (retval) {
     fprintf(stdout, "Whetstone FP benchmark ran only %f sec; ignoring", fp_time);
     return 0;
   }

   retval = dhrystone(vax_mips, int_loops, int_time, MIN_CPU_TIME);
   if (retval) {
     fprintf(stdout, "Dhrystone FP benchmark ran only %f sec; ignoring", fp_time);
     return 0;
   }

   return retval;
}
