#!/bin/bash

rm *.o *.a

export BOINC="/home/carlgt1/projects/boinc" #BOINC source code
export OPENSSL_DIR="/home/carlgt1/projects/extra/openssl-1.0.1e"
export CURL_DIR="/home/carlgt1/projects/extra/curl-7.31.0"
export PKG_CONFIG_DEBUG_SPEW=1

export ANDROIDTC="/usr/local/android/android-tc"
export TCBINARIES="$ANDROIDTC/bin"
export TCINCLUDES="$ANDROIDTC/arm-linux-androideabi"
export TCSYSROOT="$ANDROIDTC/sysroot"
export STDCPPTC="$TCINCLUDES/lib/libstdc++.a"

export PATH="$PATH:$TCBINARIES:$TCINCLUDES/bin"
export CC=arm-linux-androideabi-gcc
export CXX=arm-linux-androideabi-g++
export LD=arm-linux-androideabi-ld
export CFLAGS="--sysroot=$TCSYSROOT -Wall -O3 -fomit-frame-pointer"
export CPPFLAGS="-DANDROID -DOS_PATH_SEPARATOR='/' -DDECLARE_TIMEZONE -I./ -I$BOINC -I$BOINC/lib -I$BOINC/client -I$TCINCLUDES/include"
export CXXFLAGS="-mfloat-abi=softfp -mfpu=neon --sysroot=$TCSYSROOT -DANDROID -DANDROID_NEON -DOS_PATH_SEPARATOR='/' -Wall -I$TCINCLUDES/include -funroll-loops -fexceptions -O3 -fomit-frame-pointer"
#export CXXFLAGS="--sysroot=$TCSYSROOT -DANDROID -DOS_PATH_SEPARATOR='/' -Wall -I$TCINCLUDES/include -funroll-loops -fexceptions -O3 -fomit-frame-pointer"
export LDFLAGS="-L$TCSYSROOT/usr/lib -L$TCINCLUDES/lib -L$BOINC/lib"
export LIBS=" -llog -lc -lstdc++ -lboinc -lm"
export GDB_CFLAGS="--sysroot=$TCSYSROOT -Wall -g -I$TCINCLUDES/include"
export PKG_CONFIG_SYSROOT_DIR=$TCSYSROOT
export PKG_CONFIG_PATH=$CURL_DIR/lib/pkgconfig:$OPENSSL_DIR/lib/pkgconfig

#$CXX $CPPFLAGS $CXXFLAGS -c -o whetstone.o whetstone.cpp
#$CXX $CPPFLAGS $CXXFLAGS -c -o dhrystone.o dhrystone.cpp
#$CXX $CPPFLAGS $CXXFLAGS -c -o dhrystone2.o dhrystone2.cpp
#$CXX $CPPFLAGS $CXXFLAGS -c -o cpp.o cpp.cpp
#$CXX $CPPFLAGS $CXXFLAGS -c -o main.o main.cpp
#$LD $LDFLAGS $LIBS whetstone.o dhrystone.o dhrystone2.o cpp.o main.o

$CXX $CPPFLAGS $CXXFLAGS $LDFLAGS $LIBS whetstone.cpp dhrystone.cpp dhrystone2.cpp cpp.cpp main.cpp

